#ifndef __ETHHEADER_H_
#define __ETHHEADER_H_

#include "utils.h"

#pragma pack(push, 1)
struct _eth_header
        {
            u_char dst[ETH_ALEN];
            u_char src[ETH_ALEN];
            u_short frame_type;
        };
#pragma pack(pop)

#define ETH_HEADER_SIZE sizeof(_eth_header)
#define ETH_FRAME_IP 0x0800
#define ETH_FRAME_ARP 0x0806

class ETHHeader
{
public:
  ETHHeader(const u_char *_dst, const u_char *_src, u_short _frame_type);
  ETHHeader(const u_char *_data);
  void dump();
  void setMem(u_char *_data);
  u_short frame_type();
  const u_char *dst_MAC() const;
  const u_char *src_MAC() const;

private:
  _eth_header data;
  void data2host(void);
  void data2network(void);
};

#endif 